<?php

declare(strict_types=1);

namespace Drupal\babel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Replaces the 'string_translator.locale.lookup' service's class.
 *
 * @see https://www.drupal.org/project/drupal/issues/3533589
 */
class BabelServiceProvider implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    if ($container->hasDefinition('string_translator.locale.lookup')) {
      $container->getDefinition('string_translator.locale.lookup')
        ->setClass(BabelLocaleTranslation::class)
        ->setArgument(6, new Reference(BabelStorageInterface::class));
    }
  }

}
