<?php

declare(strict_types=1);

namespace Drupal\babel\Cache\Context;

use Drupal\Core\Cache\Context\RouteNameCacheContext;

/**
 * Whether current page is a translate form route.
 *
 * Cache context ID: 'babel_translate_form_route'.
 */
class BabelTranslateFormRoute extends RouteNameCacheContext {

  /**
   * {@inheritdoc}
   */
  public function getContext(): string {
    return in_array(parent::getContext(), ['babel.ui', 'babel.ui_pager'])
      ? 'babel_translate_form'
      : '';
  }

}
