<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\babel\BabelStorageInterface;
use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for data transfer plugins.
 */
abstract class DataTransferPluginBase extends PluginBase implements DataTransferPluginInterface, ContainerFactoryPluginInterface {

  public function __construct(
    array $configuration,
    string $pluginId,
    $pluginDefinition,
    protected readonly FileSystemInterface $fileSystem,
    protected readonly TranslationTypePluginManager $translationTypeManager,
    protected readonly BabelStorageInterface $babelStorage,
  ) {
    parent::__construct($configuration, $pluginId, $pluginDefinition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('file_system'),
      $container->get(TranslationTypePluginManager::class),
      $container->get(BabelStorageInterface::class),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration(): array {
    return $this->configuration + $this->defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function setConfiguration(array $configuration): void {
    $this->configuration = $configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [];
  }

}
