<?php

namespace Drupal\background_image;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a Background Image entity.
 *
 * @ingroup background_image
 */
interface BackgroundImageInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * General value to indicate "inherit".
   *
   * @type int
   */
  const INHERIT = -1;

  /**
   * General value to indicate "normal".
   *
   * @type int
   */
  const NORMAL = 0;

  /**
   * Never blur the background image.
   *
   * @type int
   */
  const BLUR_NONE = 0;

  /**
   * Only blur the background image after the user has scrolled.
   *
   * @type int
   */
  const BLUR_SCROLL = 1;

  /**
   * Same as BLUR_SCROLL, but also only if using the full_viewport setting.
   *
   * @type int
   */
  const BLUR_SCROLL_FULL_VIEWPORT = 2;

  /**
   * Always blur the background image.
   *
   * @type int
   */
  const BLUR_PERSISTENT = 3;

  /**
   * Attached to whole site.
   *
   * @type int
   */
  const TYPE_GLOBAL = -1;

  /**
   * Attached to an entity.
   *
   * @type int
   */
  const TYPE_ENTITY = 0;

  /**
   * Attached to an entity bundle.
   *
   * @type int
   */
  const TYPE_ENTITY_BUNDLE = 1;

  /**
   * Attached to a path or multiple paths.
   *
   * @type int
   */
  const TYPE_PATH = 2;

  /**
   * Attached to a route or multiple routes.
   *
   * @type int
   */
  const TYPE_ROUTE = 3;

  /**
   * Attached to a view page.
   *
   * @type int
   */
  const TYPE_VIEW = 4;

}
