<?php

namespace Drupal\background_image\Plugin\Block;

use Drupal\background_image\BackgroundImageManager;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides background image text block.
 *
 * @Block(
 *   id = "background_image_text",
 *   admin_label = @Translation("Background Image - Text"),
 *   category = @Translation("Background Image")
 * )
 */
class BackgroundImageTextBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  protected function baseConfigurationDefaults() {
    $defaults = parent::baseConfigurationDefaults();
    $defaults['label_display'] = 'hidden';
    return $defaults;
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $build = [];
    $background_image_manager = BackgroundImageManager::service();
    [$media, $cacheability] = $background_image_manager->getBackgroundImage();
    $build = $media ? $background_image_manager->view($media, 'image') : [];
    $cacheability->addCacheableDependency(CacheableMetadata::createFromRenderArray($build))
      ->applyTo($build);
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['label_display']['#access'] = FALSE;

    return $form;
  }

}
