<?php

namespace Drupal\backlinks_index\Drush\Commands;

use Drupal\backlinks_index\Batch\BacklinksScanBatch;
use Drupal\Core\Batch\BatchBuilder;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;
use \Drupal\backlinks_index\Services\BacklinksManager;

/**
 * Backlinks Index Drush command file.
 */
final class BacklinksIndexCommands extends DrushCommands {

  use StringTranslationTrait;

  /**
   * Constructs a LarimerCoreCommands object.
   */
  public function __construct(
    private readonly BacklinksManager $backlinksIndexManager,
  ) {
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('backlinks_index.manager'),
    );
  }

  /**
   * Reindex backlinks.
   */
  #[CLI\Command(name: 'backlinks_index:reindex', aliases: ['b_i:reindex'])]
  public function reindexBacklinks(): void {
    $this->logger()->notice('Backlinks reindexing started.');
    /** @var \Drupal\Core\Batch\BatchBuilder $builder */
    $builder = new BatchBuilder();
    $builder->setTitle($this->t('Scanning nodes'))
      ->addOperation([BacklinksScanBatch::class, 'run'])
      ->setFinishCallback([BacklinksScanBatch::class, 'finished'])
      ->setProgressMessage($this->t('Processed @current of @total items.'));;

    batch_set($builder->toArray());
    drush_backend_batch_process();
    $this->logger()->notice('Backlinks reindexing finished.');
  }

  /**
   * Purgh backlinks.
   */
  #[CLI\Command(name: 'backlinks_index:purge', aliases: ['b_i:purge'])]
  public function purgeBacklinks(): void {
    $this->logger()->notice('Purging backlinks.');
    /** @var \Drupal\Core\Batch\BatchBuilder $builder */
    $this->backlinksIndexManager->truncateBacklinks();
    $this->logger()->notice('Backlinks purged.');
  }

}
