(function (Drupal, drupalSettings) {
  'use strict';
  Drupal.behaviors.bankidSubmitOnOrderDone = {
    attach: function (context) {
      document.addEventListener('bankid', submitOnOrderDone);
    },
  };

  function submitOnOrderDone(event) {
    const settings = drupalSettings.bankidSubmitOnOrderDone[event.detail.configurationHash];
    const submit_id = settings.submitId;
    const order_ref_id = settings.orderRefId;
    if (event.detail.type === 'complete') {
      const order_ref_element = document.getElementById(order_ref_id);
      if (order_ref_element) {
        order_ref_element.value = event.detail.orderRef ?? null;
      }
      document.getElementById(submit_id)?.click();
    }

  }
})(Drupal, drupalSettings);
