<?php

declare(strict_types=1);

namespace Drupal\bankid\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines bank_id_case attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class BankIDCase extends AttributeBase {

  public function __construct(
    public readonly string $id,
    public readonly string|TranslatableMarkup $title,
    public readonly string|TranslatableMarkup|null $description,
    protected string|null $provider = NULL,
  ) {}

}
