<?php

declare(strict_types=1);

namespace Drupal\bankid;

use Drupal\bankid\ValueObjects\BankIDOrderDoneData;
use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for bank_id_case plugins.
 */
abstract class BankIDCasePluginBase extends PluginBase implements BankIDCaseInterface {

  /**
   * The private data.
   */
  protected array $private;

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function setPrivateData(array $private_data): void {
    $this->private = $private_data;
  }

  /**
   * {@inheritdoc}
   */
  public function getRequirements(): array {
    return $this->private['requirements'] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function getHiddenData(): string {
    return $this->private['hidden_data'] ?? '';
  }

  /**
   * {@inheritdoc}
   */
  public function getVisibleData(): string {
    return $this->private['visible_data'] ?? '';
  }

  /**
   * {@inheritdoc}
   */
  public function getVisibleDataFormat(): string {
    return 'plaintext';
  }

  /**
   * {@inheritdoc}
   */
  abstract public function orderCompleted(array $response): BankIDOrderDoneData;

  /**
   * {@inheritdoc}
   */
  public function orderCancelled(array $response, string $order_ref): BankIDOrderDoneData {
    return new BankIDOrderDoneData([], $order_ref, NULL, []);
  }

  /**
   * {@inheritdoc}
   */
  public function orderFailed(array $response): BankIDOrderDoneData {
    return new BankIDOrderDoneData([], $response['orderRef'] ?? NULL, NULL, []);
  }

}
