<?php

declare(strict_types=1);

namespace Drupal\bankid;

use Drupal\bankid\Attribute\BankIDCase;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * BankIdCase plugin manager.
 */
final class BankIDCasePluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/BankIDCase', $namespaces, $module_handler, BankIDCaseInterface::class, BankIDCase::class);
    $this->alterInfo('bankid_case_info');
    $this->setCacheBackend($cache_backend, 'bankid_case_plugins');
  }

}
