<?php

declare(strict_types=1);

namespace Drupal\bankid;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Factory for BankIDClientInterface.
 */
final readonly class BankIDClientFactory {

  /**
   * Constructs a ClientSelector object.
   */
  public function __construct(
    private ConfigFactoryInterface $configFactory,
    private \Closure|BankIDMockClient $bankidMock,
    private \Closure|BankIDClient $bankid,
  ) {}

  /**
   * Retrieves the appropriate BankID client based on the current environment
   * configuration.
   *
   * @return BankIDClientInterface
   *   The BankID client instance, either mock or live.
   */
  public function get(): BankIDClientInterface {
    $mode = $this->configFactory->get('bankid.settings')->get('environment');
    $bankid_client = $mode === 'mock' ? $this->bankidMock : $this->bankid;
    return $bankid_client instanceof BankIDClientInterface ? $bankid_client : $bankid_client();
  }

}
