<?php

declare(strict_types=1);

namespace Drupal\bankid;

use Drupal\user\UserInterface;

/**
 * An interface for all Integration type plugins.
 */
interface IntegrationInterface {

  /**
   * Provide the Integration label.
   *
   * @return string
   *   A string label of the Integration.
   */
  public function getLabel(): string;

  /**
   * Get the user from the response.
   *
   * @param array $response
   *   The response from the BankID service.
   *
   * @return \Drupal\user\UserInterface|null
   *   The user object.
   */
  public function getUser(array $response): UserInterface|NULL;

  /**
   * Create the user from the response.
   *
   * @param array $response
   *   The response from the BankID service.
   *
   * @return \Drupal\user\UserInterface|null
   *   The user object.
   */
  public function createUser(array $response): UserInterface|null;

  /**
   * Get the hash of a string.
   *
   * @param string $str
   *   The string to hash.
   *
   * @return string
   *   The hashed string.
   */
  public function hash(string $str): string;

  // phpcs:disable
  // Plugin method sketch
  /**
   * failed
   * cancelled
   * completed
   * started
   */

  // Form builder sketch
  /**
   * buildAuthenticateFrom(Requirements)
   * buildSignForm(Requirements, VisibleData, HiddenData)
   */
  // phpcs:enable
}
