<?php

declare(strict_types=1);

namespace Drupal\bankid\Plugin\BankID;

use Drupal\bankid\IntegrationBase;
use Drupal\user\UserInterface;

/**
 * Provides default integration.
 *
 * @Integration(
 *   id = "default",
 *   label = @Translation("Default integration.")
 * )
 *
 * @ TODO consider if this could be handled by the BankIDCase plugin instead.
 */
class DefaultIntegration extends IntegrationBase {

  /**
   * {@inheritdoc}
   */
  public function getUser(array $response): UserInterface|NULL {
    $authname = $this->hash($response['completionData']['user']['personalNumber']);

    return $this->externalAuth->load($authname, self::PROVIDER_NAME) ?: NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function createUser(array $response): UserInterface {
    $ssn = $response['completionData']['user']['personalNumber'];
    $authname = $this->hash($ssn);

    // Username has a character limit of 60. So we can't use the hashed SSN as
    // the username.
    $name = hash('md5', $authname);

    return $this->externalAuth->register($authname, self::PROVIDER_NAME, ['name' => $name]);
  }

}
