<?php

namespace Drupal\bankid\ValueObjects;

use Drupal\bankid\Enum\OrderOperation;

/**
 * Data that is sent to the client.
 */
final class CaseData {

  public function __construct(
    public string $pluginId,
    public array|null $pluginConfiguration,
    public array|null $private,
    public OrderOperation $operation,
  ) {
    // Noop.
  }

  /**
   * Serialize non sensitive properties.
   *
   * @return array
   *   An array of non sensitive serialized properties.
   */
  public function __serialize(): array {
    return [
      'pluginId' => $this->pluginId,
      'pluginConfiguration' => $this->pluginConfiguration,
      'operation' => $this->operation->value,
    ];
  }

  /**
   * Unserialize non-sensitive properties.
   *
   * @param array $data
   *   An array of non-sensitive serialized properties.
   */
  public function __unserialize(array $data): void {
    $this->pluginId = $data['pluginId'];
    $this->pluginConfiguration = $data['pluginConfiguration'];
    $this->private = NULL;
    $this->operation = OrderOperation::from($data['operation']);
  }

  /**
   * Set private data.
   *
   * @param array $private
   *   The private data.
   */
  public function setPrivate(array $private): void {
    $this->private = $private;
  }

}
