# Barba JS

## Introduction

This module integrates the **Barba.js** library into Drupal.

Barba.js is a small, fast and modern JavaScript library that enables **smooth
and fluid transitions between pages**, making your website behave like a
**Single Page Application (SPA)**.

- Website: https://barba.js.org/
- GitHub: https://github.com/barbajs/barba

---

## Features

- Smooth transitions between pages
- Improved user experience through SPA-like navigation
- Works with modern browsers
- Easy to extend using Barba hooks (enter, leave, etc.)
- Lightweight (~7KB minified)

---

## Requirements

- No external dependencies required (Barba.js is included via CDN)

---

## Installation

1. Download this module: https://www.drupal.org/project/barbajs
2. Place it under `/modules/contrib/barbajs`
3. Enable the module through the Drupal admin interface or Drush:

   ```bash
   drush en barbajs
   ```
---

## Usage
Barba.js will be automatically attached to all frontend pages.
You can define your custom transitions using JavaScript in your theme or module.

Example Initialization (Place in your theme’s JS):

```javascript
barba.init({
  transitions: [{
    name: 'fade',
    leave({ current }) {
      return gsap.to(current.container, { opacity: 0 });
    },
    enter({ next }) {
      return gsap.from(next.container, { opacity: 0 });
    }
  }]
});
```

For more usage check official document:

  - https://barba.js.org/docs/getstarted/intro/

---

## 👤 MAINTAINERS

The following person is actively maintaining this module:

- **Mahyar Sabeti** ([mahyarsbt](https://www.drupal.org/u/mahyarsbt))

---
### DEMO
https://barba.js.org/examples/
