(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.barbaRouter = factory());
})(this, (function () {
  var version = "2.1.11";

  /**
   * @barba/router
   * <br><br>
   * ## Barba Router.
   *
   * - Add `route` to Barba transitions resolution
   *
   * @module router
   * @preferred
   */
  var Router = /*#__PURE__*/function () {
    function Router() {
      this.name = '@barba/router';
      this.version = version;
      this.barba = void 0;
      this.logger = void 0;
      this.routeNames = [];
      this.routesByName = {};
    }
    var _proto = Router.prototype;
    /**
     * Plugin installation.
     */
    _proto.install = function install(barba, _temp) {
      var _this = this;
      var _ref = _temp === void 0 ? {} : _temp,
        _ref$routes = _ref.routes,
        routes = _ref$routes === void 0 ? [] : _ref$routes;
      this.logger = new barba.Logger(this.name);
      this.logger.info(this.version);
      this.barba = barba;
      routes.forEach(function (route) {
        var name = route.name,
          path = route.path;
        var keys = [];
        var regex = _this.barba.helpers.pathToRegexp(path, keys);
        if (_this.routeNames.indexOf(name) > -1) {
          console.warn("[@barba/router] Duplicated route name (" + name + ")");
        } else {
          _this.routeNames.push(name);
          _this.routesByName[name] = {
            keys: keys,
            path: path,
            regex: regex
          };
        }
      });
      // Add property to "pageSchema" (current, next)
      barba.schemaPage.route = undefined;
    }
    /**
     * Plugin initialisation.
     */;
    _proto.init = function init() {
      // Wait for store initialization then add new rule for routes
      this.barba.transitions.store.add('rule', {
        position: 1,
        value: {
          name: 'route',
          type: 'object'
        }
      });
      // Register hooks
      this.barba.hooks.page(this.resolveRoutes, this);
      this.barba.hooks.reset(this.resolveRoutes, this);
    }
    /**
     * Resolve URL to route name.
     */;
    _proto.resolveUrl = function resolveUrl(url) {
      var _this2 = this;
      var _this$barba$url$parse = this.barba.url.parse(url),
        path = _this$barba$url$parse.path;
      var output = {
        name: '',
        params: {}
      };
      /* tslint:disable:no-shadowed-variable */
      var _loop = function _loop() {
        var name = _this2.routeNames[i];
        var _this2$routesByName$n = _this2.routesByName[name],
          regex = _this2$routesByName$n.regex,
          keys = _this2$routesByName$n.keys;
        var res = regex.exec(path);
        if (res !== null) {
          output.name = name;
          keys.forEach(function (key, i) {
            output.params[key.name] = res[i + 1];
          });
          return {
            v: output
          };
        }
      };
      for (var i = 0, l = this.routeNames.length; i < l; i++) {
        var _ret = _loop();
        if (typeof _ret === "object") return _ret.v;
      }
      return null;
    }
    /**
     * Hooks: do, reset.
     *
     * - Update `current` and `next` data
     */;
    _proto.resolveRoutes = function resolveRoutes(data) {
      var current = data.current,
        next = data.next;
      current.route = current.url.href ? this.resolveUrl(current.url.href) : undefined;
      next.route = next.url.href ? this.resolveUrl(next.url.href) : undefined;
    };
    return Router;
  }();
  var router = new Router();

  return router;

}));
