(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.barbaCss = factory());
})(this, (function () {
  var version = "2.1.16";

  /**
   * @barba/css
   * <br><br>
   * ## Barba CSS.
   *
   * - Add CSS classes
   * - Manage CSS transitions
   *
   * @module css
   * @preferred
   */
  var Css = /*#__PURE__*/function () {
    function Css() {
      this.name = '@barba/css';
      this.version = version;
      this.barba = void 0;
      this.logger = void 0;
      this.prefix = 'barba';
      this.callbacks = {};
      this.cb = void 0;
      this._hasTransition = false;
    } // Check if transition property applied
    var _proto = Css.prototype;
    /**
     * Plugin installation.
     */
    _proto.install = function install(barba) {
      this.logger = new barba.Logger(this.name);
      this.logger.info(this.version);
      this.barba = barba;
      this._once = this._once.bind(this);
      this._leave = this._leave.bind(this);
      this._enter = this._enter.bind(this);
    }
    /**
     * Plugin installation.
     */;
    _proto.init = function init() {
      // Register hooks to get prefix
      this.barba.hooks.before(this._getPrefix, this);
      this.barba.hooks.beforeOnce(this._getPrefix, this);
      // Register hook for CSS classes
      this.barba.hooks.beforeOnce(this._beforeOnce, this);
      this.barba.hooks.afterOnce(this._afterOnce, this);
      this.barba.hooks.beforeLeave(this._beforeLeave, this);
      this.barba.hooks.afterLeave(this._afterLeave, this);
      this.barba.hooks.beforeEnter(this._beforeEnter, this);
      this.barba.hooks.afterEnter(this._afterEnter, this);
      // Override main transitions
      this.barba.transitions.once = this._once;
      this.barba.transitions.leave = this._leave;
      this.barba.transitions.enter = this._enter;
      // Add empty default transition (force prepend)
      /* istanbul ignore next */
      this.barba.transitions.store.all.unshift({
        name: 'barba',
        once: function once() {},
        leave: function leave() {},
        enter: function enter() {} // tslint:disable-line:no-empty
      });
      this.barba.transitions.store.update();
    }
    /**
     * Initial state.
     */;
    _proto.start = function start(container, kind) {
      try {
        var _this = this;
        // Set initial CSS values
        _this.add(container, kind); // CSS: add kind
        return Promise.resolve(_this.barba.helpers.nextTick()).then(function () {
          // Apply CSS transition
          _this.add(container, kind + "-active"); // CSS: add kind-active
          return Promise.resolve(_this.barba.helpers.nextTick()).then(function () {});
        });
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * Next frame state.
     */
    ;
    _proto.next = function next(container, kind) {
      try {
        var _this2 = this;
        _this2._hasTransition = _this2._checkTransition(container);
        return Promise.resolve(function () {
          if (_this2._hasTransition) {
            // We need to listen the end of the animation
            return new Promise(function (resolve) {
              try {
                _this2.cb = resolve;
                _this2.callbacks[kind] = resolve;
                container.addEventListener('transitionend', resolve, false);
                _this2.remove(container, kind); // CSS: remove kind
                return Promise.resolve(_this2.barba.helpers.nextTick()).then(function () {
                  _this2.add(container, kind + "-to"); // CSS: add kind-to
                  return Promise.resolve(_this2.barba.helpers.nextTick()).then(function () {});
                });
              } catch (e) {
                return Promise.reject(e);
              }
            });
          } else {
            _this2.remove(container, kind); // CSS: remove kind
            return Promise.resolve(_this2.barba.helpers.nextTick()).then(function () {
              _this2.add(container, kind + "-to"); // CSS: add kind-to
              return Promise.resolve(_this2.barba.helpers.nextTick()).then(function () {});
            });
          }
        }());
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * Final state.
     */
    ;
    _proto.end = function end(container, kind) {
      try {
        var _this3 = this;
        _this3.remove(container, kind + "-to"); // CSS: remove kind-to
        _this3.remove(container, kind + "-active"); // CSS: remove kind-active
        container.removeEventListener('transitionend', _this3.callbacks[kind]);
        _this3._hasTransition = false;
        return Promise.resolve();
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * Add CSS classes.
     */
    ;
    _proto.add = function add(el, step) {
      el.classList.add(this.prefix + "-" + step);
    }
    /**
     * Remove CSS classes.
     */;
    _proto.remove = function remove(el, step) {
      el.classList.remove(this.prefix + "-" + step);
    }
    /**
     * Get CSS prefix from transition `name` property.
     */;
    _proto._getPrefix = function _getPrefix(data, t) {
      this.prefix = t.name || 'barba';
    }
    /**
     * Check if CSS transition is applied
     */;
    _proto._checkTransition = function _checkTransition(container) {
      // DEV: check for CSS animation property?
      return getComputedStyle(container).transitionDuration !== '0s';
    }
    /**
     * `beforeOnce` hook.
     */;
    _proto._beforeOnce = function _beforeOnce(data) {
      return this.start(data.next.container, 'once');
    }
    /**
     * `once` hook.
     */;
    _proto._once = function _once(data, t) {
      try {
        var _this4 = this;
        return Promise.resolve(_this4.barba.hooks["do"]('once', data, t)).then(function () {
          return _this4.next(data.next.container, 'once');
        });
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * `afterOnce` hook.
     */
    ;
    _proto._afterOnce = function _afterOnce(data) {
      return this.end(data.next.container, 'once');
    }
    /**
     * `beforeLeave` hook.
     */;
    _proto._beforeLeave = function _beforeLeave(data) {
      return this.start(data.current.container, 'leave');
    }
    /**
     * `leave` hook.
     */;
    _proto._leave = function _leave(data, t) {
      try {
        var _this5 = this;
        return Promise.resolve(_this5.barba.hooks["do"]('leave', data, t)).then(function () {
          return _this5.next(data.current.container, 'leave');
        });
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * `afterLeave` hook.
     */
    ;
    _proto._afterLeave = function _afterLeave(data) {
      this.end(data.current.container, 'leave');
      // For CSS transitions, we need to remove current container
      // directly after the leave transition
      this.barba.transitions.remove(data);
      return Promise.resolve();
    }
    /**
     * `beforeEnter` hook.
     */;
    _proto._beforeEnter = function _beforeEnter(data) {
      return this.start(data.next.container, 'enter');
    }
    /**
     * `enter` hook.
     */;
    _proto._enter = function _enter(data, t) {
      try {
        var _this6 = this;
        return Promise.resolve(_this6.barba.hooks["do"]('enter', data, t)).then(function () {
          return _this6.next(data.next.container, 'enter');
        });
      } catch (e) {
        return Promise.reject(e);
      }
    }
    /**
     * `afterEnter` hook.
     */
    ;
    _proto._afterEnter = function _afterEnter(data) {
      return this.end(data.next.container, 'enter');
    };
    return Css;
  }();
  var css = new Css();

  return css;

}));
