(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.barbaPrefetch = factory());
})(this, (function () {
  var version = "2.2.0";

  /**
   * @module prefetch/polyfills
   */
  /**
   * Copyright 2018 Google Inc.
   *
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */
  // [source](https://github.com/GoogleChromeLabs/quicklink/blob/master/src/request-idle-callback.mjs)
  // RIC and shim for browsers setTimeout() without it
  var requestIdleCallback =
  // @ts-ignore
  window.requestIdleCallback || function ric(cb) {
    var start = Date.now();
    return setTimeout(function () {
      cb({
        didTimeout: false,
        timeRemaining: function timeRemaining() {
          return Math.max(0, 50 - (Date.now() - start));
        }
      });
    }, 1);
  };

  /**
   * @barba/prefetch
   * <br><br>
   * ## Barba prefetch.
   *
   * @module prefetch
   * @preferred
   */
  var Prefetch = /*#__PURE__*/function () {
    function Prefetch() {
      this.name = '@barba/prefetch';
      this.version = version;
      this.barba = void 0;
      this.logger = void 0;
      this.observer = void 0;
      this.root = void 0;
      this.timeout = void 0;
      this.limit = void 0;
      this.toPrefetch = new Set();
    }
    var _proto = Prefetch.prototype;
    /**
     * Plugin installation.
     */
    _proto.install = function install(barba, _temp) {
      var _ref = _temp === void 0 ? {} : _temp,
        _ref$root = _ref.root,
        root = _ref$root === void 0 ? document.body : _ref$root,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? 2e3 : _ref$timeout,
        _ref$limit = _ref.limit,
        limit = _ref$limit === void 0 ? 0 : _ref$limit;
      this.logger = new barba.Logger(this.name);
      this.logger.info(this.version);
      this.barba = barba;
      this.root = root;
      this.timeout = timeout;
      this.limit = limit;
    }
    /**
     * Plugin initialisation.
     */;
    _proto.init = function init() {
      var _this = this;
      if (this.barba.prefetchIgnore) {
        this.logger.warn('barba.prefetchIgnore is enabled');
        return;
      }
      if (this.barba.cacheIgnore) {
        this.logger.warn('barba.cacheIgnore is enabled');
        return;
      }
      /**
       * Init intersection observer
       * when intersecting, it will check if URL should be prefetched
       * then unobserve the element
       * and, if no cache data, fetch the page
       */
      /* istanbul ignore next */
      this.observer = new IntersectionObserver(function (entries) {
        entries.forEach(function (entry) {
          if (!entry.isIntersecting) {
            return;
          }
          var link = entry.target;
          var href = _this.barba.url.getAbsoluteHref(_this.barba.dom.getHref(link));
          if (!_this.toPrefetch.has(href)) {
            return;
          }
          _this.observer.unobserve(link);
          // Prefetch and cache
          if (!_this.barba.cache.has(href)) {
            _this.barba.cache.set(href, _this.barba.request(href, _this.barba.timeout, _this.barba['onRequestError'].bind(_this.barba, 'barba'),
            // tslint:disable-line:no-string-literal
            _this.barba.cache, _this.barba.headers)["catch"](function (error) {
              _this.logger.error(error);
            }), 'prefetch', 'pending');
          } else {
            _this.barba.cache.update(href, {
              action: 'prefetch'
            });
          }
        });
      });
      this.observe();
      // Register hooks
      this.barba.hooks.after(this.observe, this);
    }
    /* istanbul ignore next */;
    _proto.observe = function observe() {
      var _this2 = this;
      var timeout = this.timeout;
      requestIdleCallback(function () {
        var links = Array.from(_this2.root.querySelectorAll('a'));
        if (_this2.limit > 0) {
          links = links.slice(0, _this2.limit);
        }
        // If not, find all links and use IntersectionObserver.
        links.forEach(function (el) {
          var link = el;
          var href = _this2.barba.dom.getHref(link);
          if (!_this2.barba.cache.has(href) && !_this2.barba.prevent.checkHref(href) && !_this2.barba.prevent.checkLink(link, {}, href)) {
            _this2.observer.observe(el);
            _this2.toPrefetch.add(href);
          }
        });
      }, {
        timeout: timeout
      });
    };
    return Prefetch;
  }();
  var prefetch = new Prefetch();

  return prefetch;

}));
