/**
 * @file
 * Contains definition of the behaviour Barba settings.
 */

(function ($, window, Drupal, once) {
  "use strict";

  /**
   * Provide the summary information for the barba settings vertical tabs.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior for the barba settings summaries.
   */
  Drupal.behaviors.barbaSettingsSummary = {
    attach() {
      // The drupalSetSummary method required for this behavior is not available
      // on the Barba settings page, so we need to make sure this
      // behavior is processed only if drupalSetSummary is defined.
      if (typeof $.fn.drupalSetSummary === 'undefined') {
        return;
      }

      $(once('barba-file-types', '[data-drupal-selector="edit-file-types"]'),
      ).drupalSetSummary((context) => {
        const enabled = {
          core: $(context).find('[data-drupal-selector="edit-core"]').prop('checked'),
          css: $(context).find('[data-drupal-selector="edit-css"]').prop('checked'),
          prefetch: $(context).find('[data-drupal-selector="edit-prefetch"]').prop('checked'),
          router: $(context).find('[data-drupal-selector="edit-router"]').prop('checked'),
        };

        // اگر همه فعال باشند
        if (enabled.core && enabled.css && enabled.prefetch && enabled.router) {
          return Drupal.t('Core and all plugins enabled');
        }

        const values = [];
        if (enabled.core) {
          values.push(Drupal.t('Core enabled'));
        }
        if (enabled.css) {
          values.push(Drupal.t('CSS enabled'));
        }
        if (enabled.prefetch) {
          values.push(Drupal.t('Prefetch enabled'));
        }
        if (enabled.router) {
          values.push(Drupal.t('Router enabled'));
        }

        return values.join(', ');
      });

      $(once('barba-theme-groups', '[data-drupal-selector="edit-theme-groups"]'),
      ).drupalSetSummary((context) => {
        const $themes = $(context).find(
          'select[name="themes\[\]"]',
        );
        if (!$themes.length || !$themes[0].value) {
          return Drupal.t('Not restricted');
        }

        return Drupal.t('Restricted to !theme', { '!theme': $themes.val() });
      });

      $(once('barba-request-path', '[data-drupal-selector="edit-request-path"]'),
      ).drupalSetSummary((context) => {
        const $pages = $(context).find(
          'textarea[name="pages"]',
        );
        if (!$pages.length || !$pages[0].value) {
          return Drupal.t('Not restricted');
        }

        return Drupal.t('Restricted to certain pages');
      });
    },
  };

})(jQuery, window, Drupal, once);
