# Basic Ads Module

A comprehensive Drupal module for managing advertisements with placements, scheduling, and display blocks.

## Features

- **Ad Placement Taxonomy**: Organize ads by where they should appear (Header, Sidebar, Footer, etc.)
- **Advertisement Content Type**: Complete content type with image, text, and link fields
- **Scheduling System**: Set start and end dates for ad campaigns
- **Weight-based Ordering**: Control which ads display first
- **Views Integration**: Pre-configured Views blocks for each placement
- **Automatic Expiration**: Cron job automatically unpublishes expired ads
- **Impression Tracking**: Automatically track every time an ad is displayed
- **Click Tracking**: Track clicks with anonymized IP addresses for privacy compliance
- **Statistics Dashboard**: View detailed analytics including CTR (Click-Through Rate)
- **Privacy-First**: IP addresses are anonymized (GDPR/CCPA compliant)
- **Automatic Cleanup**: Old tracking data (>1 year) is automatically purged via cron

## Installation

1. Place the `basic_ads` module in your `/modules/custom` directory
2. Enable the module: `drush en basic_ads -y`
3. Clear cache: `drush cr`

The module will automatically create:
- Ad Placement vocabulary with 5 default terms
- Advertisement content type with all necessary fields
- Views with block displays for each placement

## Module Structure

```
basic_ads/
├── basic_ads.info.yml
├── basic_ads.install
├── basic_ads.module
├── basic_ads.routing.yml
├── basic_ads.libraries.yml
├── README.md
├── config/
│   └── install/
│       └── views.view.advertisements.yml
├── src/
│   ├── Plugin/Block/
│   │   └── AdvertisementBlock.php
│   └── Controller/
│       └── AdStatsController.php
│       └── AdTrackingController.php
└── templates/
    └── node--advertisement.html.twig
```

## Fields Created

### Advertisement Content Type

- **Title**: Ad name (standard node title)
- **Ad Image**: Required image field with alt text
- **Ad Link**: URL where the ad should link (optional)
- **Ad Placement**: Taxonomy reference to placement locations (required, multi-select)
- **Start Date**: When the ad should begin displaying (optional)
- **End Date**: When the ad should stop displaying (optional)
- **Weight**: Numeric value for display ordering (lower numbers appear first)

## Ad Placement Taxonomy

Default placement terms created on installation:

1. **Header** - Advertisement placement in the header area
2. **Sidebar** - Advertisement placement in the sidebar
3. **Footer** - Advertisement placement in the footer
4. **Content Top** - Advertisement placement above main content
5. **Content Bottom** - Advertisement placement below main content

You can add more placement terms as needed.

## Views & Blocks

The module creates an "Basic Ads" view with the following block displays:

- **Ads: Block 1** - Shows ad for placement, Placement chosen via contextual filter

### Placing Ad Blocks

1. Go to **Structure → Block layout**
2. Click "Place block" in your desired region
3. Search for "Basic Ad block (by placement)" to find the ad blocks
4. Configure and save

## Creating Advertisements

1. Go to **Content → Add content → Advertisement**
2. Fill in the required fields:
    - Title (internal name for the ad)
    - Ad Image (with alt text)
    - Ad Placement (select one or more locations)
3. Optionally add:
    - Ad Link URL where users should be directed
    - Start Date (leave empty to display immediately)
    - End Date (leave empty for no expiration)
    - Weight (default is 0, use negative numbers for higher priority)
4. Save and publish

## Scheduling Logic

- **No Start Date**: Ad displays immediately when published
- **With Start Date**: Ad displays only after the start date/time
- **No End Date**: Ad displays indefinitely
- **With End Date**: Ad stops displaying after the end date/time
- **Expired Ads**: Automatically unpublished by cron

## Display Logic

Ads are filtered and sorted by:

1. **Published status** (only published ads show)
2. **Content type** (only advertisement nodes)
3. **Placement** (matches the block's placement argument)
4. **Schedule** (within start/end date range, or no dates set)
5. **Weight** (ascending - lower weights first)
6. **Created date** (descending - newer ads first as tiebreaker)

## Theming

The module includes a custom template: `node--advertisement.html.twig`

Features:
- Wraps ad in a link if Ad Link field is populated
- Opens links in new tab with `target="_blank"`
- Adds security attributes (`rel="noopener noreferrer"`)
- Includes both image and body text
- Adds helpful CSS classes for styling

### Custom Styling

Add CSS to your theme:

```css
.advertisement {
  margin-bottom: 1rem;
}

.advertisement .ad-link {
  display: block;
  text-decoration: none;
  transition: opacity 0.3s;
}

.advertisement .ad-link:hover {
  opacity: 0.8;
}

.advertisement .ad-content {
  position: relative;
}

.advertisement .ad-text {
  margin-top: 0.5rem;
  font-size: 0.9rem;
}
```

## Permissions

The module uses standard Drupal permissions:

- **Access content**: Required to view ads
- **Create advertisement content**: Create new ads
- **Edit own advertisement content**: Edit ads you created
- **Edit any advertisement content**: Edit all ads
- **Delete own advertisement content**: Delete ads you created
- **Delete any advertisement content**: Delete all ads

Configure at **People → Permissions**.

## Cron Integration

The module includes a cron hook that:
- Runs on every cron execution
- Finds all published ads with end dates in the past
- Automatically unpublishes expired ads
- Logs each unpublished ad

Ensure cron is running regularly for automatic expiration.

## Uninstallation

The module's uninstall hook will:
- Delete all advertisement nodes
- Delete the advertisement content type
- Delete all ad placement terms
- Delete the ad placement vocabulary
- Clean up field storage
- Delete databases tables created by the module

## Extending the Module

### Adding New Placements

1. Go to **Structure → Taxonomy → Ad Placement**
2. Click "Add term"
3. Enter the placement name and description
4. The new placement will automatically be available in the Ad Placement field

### Modifying the View

1. Go to **Structure → Views → Advertisements**
2. Edit displays or add new block displays as needed
3. Each block display can have different:
    - Number of items shown
    - Contextual filters
    - Display formats

### Adding Custom Fields

Additional fields can be added to the Advertisement content type:
- **Impression tracking**: Number field for tracking views
- **Click tracking**: Link to external tracking services
- **Priority**: Additional field for fine-grained control
- **Target audience**: Taxonomy for demographic targeting

## Troubleshooting

**Ads not displaying:**
- Check that ads are published
- Verify the ad placement matches the block location
- Check start/end dates are correct
- Ensure the block is placed in a visible region
- Clear Drupal cache

**Schedule not working:**
- Verify dates are in the correct format
- Check your site's timezone settings
- Ensure cron is running for expired ad cleanup
- Clear cache after changing dates

**Images not showing:**
- Verify file permissions on `sites/default/files/ads/images/`
- Check image style configuration
- Ensure the image field is displayed in the view mode

## Support

For issues or feature requests, please consult the Drupal documentation or community forums.

## License

GPL-2.0-or-later
