/* jshint esversion: 6 */
/* globals Drupal: false, once: false */
// noinspection JSUnresolvedReference
(function (Drupal, once) {
    'use strict';
    Drupal.behaviors.basicAdsTracking = {
        attach: function (context) {
            // Track views for all ads on the page
            once('ad-view-tracking', 'article[data-ad-id]', context).forEach(function (adElement) {
                const adId = adElement.getAttribute('data-ad-id');
                const placement = adElement.getAttribute('data-ad-placement') || '';
                const encoded = encodeURIComponent(placement);
                // Track the view if placement exists, skip full node view
                if (placement !== '') {
                    const url = '/ad/view/' + adId + (placement ? '?placement=' + encoded : '');
                    window.fetch(url, {
                        method: 'GET',
                        credentials: 'same-origin'
                    }).catch(function (error) {
                        console.debug('Ad view tracking failed:', error);
                    });
                }
            });
        }
    };
})(Drupal, once);