<?php

namespace Drupal\basic_ads\Service;

/**
 * Stores the current ad placement term ID for the request.
 */
final class PlacementStorage {

    protected ?int $termId = NULL;

    public function set(int $term_id): void {
        $this->termId = $term_id;
    }

    public function get(): ?int {
        return $this->termId;
    }

    public function has(): bool {
        return $this->termId !== NULL;
    }
}
