<?php

namespace Drupal\basic_ads\Service;

/**
 * Stores the current ad placement term ID for the request.
 */
final class PlacementStorage {

  /**
   * The current term ID.
   *
   * @var int|null
   */
  protected ?int $termId = NULL;

  /**
   * Set the term ID.
   *
   * @param int $term_id
   *   The term ID to set.
   */
  public function set(int $term_id): void {
    $this->termId = $term_id;
  }

  /**
   * Get the term ID.
   *
   * @return int|null
   *   The term ID or NULL if not set.
   */
  public function get(): ?int {
    return $this->termId;
  }

  /**
   * Check if a term ID has been set.
   *
   * @return bool
   *   TRUE if a term ID is set, FALSE otherwise.
   */
  public function has(): bool {
    return $this->termId !== NULL;
  }

}
