# Basic cart

Basic cart is a very simple shopping cart/checkout process for Drupal,
that just sends 2 emails after each order. Along with the shopping cart,
this module also provides a block where you can view your cart's content.

It's ideal for small websites with only a few products or other content types
being sold, for example touristic offers.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/basic_cart).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/basic_cart).

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Install the module
1. If the goods you want to sell don't exist on your website, create a new
   content type for them. If you already have a content type for them you can
   skip this step
1. Select the content type/s on the module configuration page: Configuration -
   Basic Cart or `admin/config/basic_cart/settings`
1. Create a view for the content type/s to get the shop's overview. If you
   already have it, you can skip this step
1. You have a block with the cart preview. Activate it ;-)
1. Start to add you're products in the newly created content type or in the one
   you already have

## Features

- The possibility of choosing the content types that can be added to the cart
- The possibility of sending, or not, an email to the customer once an order is
  placed
- Custom email messages for both the site administrator and the customer, along
  with the order details
- A block with the contents of your shopping cart

## Maintainers

- [Alex Dicianu](https://www.drupal.org/u/alex-dicianu)
- Norman Kämper-Leymann - [norman.lol](https://www.drupal.org/u/normanlol)
- Karthikeyan
  Manivasagam - [karthikeyan-manivasagam](https://www.drupal.org/u/karthikeyan-manivasagam)
- Kuhikar Parag - [kuhikar](https://www.drupal.org/u/kuhikar)
