(function (Drupal, drupalSettings, once) {

  /**
   * Add an input element to the add to cart button for entering a quantity.
   */
  Drupal.behaviors.basicCartQuantityInput = {
    attach(context) {
      once('basic-cart-quantity-input', '.addtocart-quantity-wrapper-container', context).forEach(function (wrapper) {

        const this_id = wrapper.id;
        const id_split = this_id.split("_");
        const dynamic_id = 'quantitydynamictext_' + id_split[1];
        const quantity_label = drupalSettings.basic_cart.label_value ?? 'Quantity';

        wrapper.innerHTML = `
          <label for="${dynamic_id}" class="js-form-required form-required ${drupalSettings.basic_cart.label_class}">
            ${quantity_label}
          </label>
          <input
            type="number"
            min="1"
            value="1"
            class="quantity_dynamic_text form-text required ${drupalSettings.basic_cart.textfield_class}"
            id="${dynamic_id}"
          >`;
      })
    }
  };

  /**
   * Add to cart functionality for when users click the add to cart button.
   */
  Drupal.behaviors.basicCartAddToCart = {
    attach(context) {
      once('basic-cart-add-to-cart', '.basic_cart-get-quantity', context).forEach(function (button) {
        // 1. Click the button.
        button.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();

          const this_id = button.id;
          const id_split = this_id.split("_");
          const id = id_split[1];

          // 2. Show the throbber.
          const basic_cart_throbber = `
            <div id="basic-cart-ajax-progress-throbber_${id}" class="basic_cart-ajax-progress-throbber ajax-progress ajax-progress-throbber">
              <div class="basic_cart-throbber throbber">&nbsp;</div>
            </div>`;
          document.getElementById('forquantitydynamictext_' + id).insertAdjacentHTML('afterend', basic_cart_throbber)

          // 3. Add to cart.
          const quantity = document.getElementById('quantitydynamictext_' + id).value;
          if (button.classList.contains('use-basic_cart-ajax')) {
            ajaxAddToCart(button, quantity, id)
          } else {
            window.location.href = this.href + quantity;
          }
        })
      })
    }
  };

  function ajaxAddToCart(button, quantity, id) {
    const url = String(button.href) + String(quantity);
    const throbber = document.getElementById('basic-cart-ajax-progress-throbber_' + id);

    fetch(url, {
      method: 'GET',
      credentials: 'same-origin',
      headers: { Accept: 'application/json' }
    })
      .then(function (response) {
        if (!response.ok) {
          throw response;
        } else {
          return response.json();
        }
      })
      .then(function (result) {
        document.querySelectorAll('.basic_cart-grid').forEach(function (grid) {
          grid.innerHTML = result.block ?? ''
        });
        // Update the small cart icon item number.
        document.querySelectorAll('.basic_cart-circles').forEach(function (circle) {
          circle.innerHTML = result.count ?? ''
        });

        // Replace the add to cart button with an animated messages.
        const element = document.getElementById(String(result.id));
        if (element) {
          element.style.display = 'none';
          element.innerHTML = result.text ?? '';
          element.style.transition = 'opacity .6s';
          element.style.opacity = '0';
          element.style.display = 'block';
          requestAnimationFrame(function () {
            element.style.opacity = '1';
          });
          setTimeout(function () {
            element.style.transition = 'opacity 2s';
            element.style.opacity = '0';
            setTimeout(function () {
              element.style.display = 'none';
            }, 2000);
          }, 1000);
        }

        // Remove the throbber.
        if (throbber) {
          throbber.remove()
        }
      })
      // Handle errors.
      .catch(function (error) {
        if (throbber) {
          throbber.remove()
        }
        const message = document.getElementById('ajax-addtocart-message-' + id);
        if (error.status === 403) {
          message.innerHTML = `<p class="messages messages--error">${Drupal.t('You are not authorized to add')}</p>`;
        } else {
          message.innerHTML = `<p class="messages messages--error">${Drupal.t('Contact site administrator')}</p>`;
        }
      });
  }

}(Drupal, drupalSettings, once));
