<?php

namespace Drupal\basic_cart\Plugin\Action;

use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Action\ActionBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Provides an Enable add to cart action.
 *
 * @Action(
 *   id = "basic_cart_enable_add_to_cart",
 *   label = @Translation("Enable add to cart"),
 *   type = "node",
 *   category = @Translation("Basic Cart"),
 * )
 */
class EnableAddToCart extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function access($entity, ?AccountInterface $account = NULL, $return_as_object = FALSE): AccessResultInterface|bool {
    /** @var \Drupal\Core\Entity\ContentEntityInterface $entity */
    if (!$entity->hasField('add_to_cart')) {
      return FALSE;
    }
    $access = $entity->access('update', $account, TRUE)
      ->andIf($entity->get('add_to_cart')->access('edit', $account, TRUE));
    return $return_as_object ? $access : $access->isAllowed();
  }

  /**
   * {@inheritdoc}
   */
  public function execute(?ContentEntityInterface $entity = NULL): void {
    $entity->set('add_to_cart', TRUE)->save();
  }

}
