<?php

namespace Drupal\basket;

use Drupal\Core\TempStore\SharedTempStore as SharedTempStoreBase;

/**
 * Extends the SharedTempStore to provide storage capabilities.
 */
class SharedTempStore extends SharedTempStoreBase {

  /**
   * Sets a value associated with the provided key.
   *
   * @param string $key
   *   The key used to store the corresponding value.
   * @param mixed $value
   *   The value to be stored.
   */
  public function set($key, $value) {
    if (!empty($GLOBALS['config']['basket']['not_use_session'])) {
      parent::set($key, $value);
    }
    else {
      $_SESSION[$key] = $value;
    }
  }

  /**
   * Retrieves the value associated with the provided key.
   *
   * @param string $key
   *   The key used to retrieve the corresponding value.
   */
  public function get($key) {
    if (!empty($GLOBALS['config']['basket']['not_use_session'])) {
      return parent::get($key);
    }
    else {
      return $_SESSION[$key] ?? NULL;
    }
  }

  /**
   * Deletes a value from this SharedTempStore for a given key.
   *
   * @param string $key
   *   The key of the data to delete.
   */
  public function delete($key) {
    if (!empty($GLOBALS['config']['basket']['not_use_session'])) {
      parent::delete($key);
    }
    else {
      $_SESSION[$key] = NULL;
    }
  }

  /**
   * Ensures that an anonymous session is initiated if not already present.
   */
  protected function ensureAnonymousSession() {}

}
