<?php

namespace Drupal\batch_content_sync\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\ReplaceCommand;

class SettingsForm extends ConfigFormBase {

  protected function getEditableConfigNames() {
    return ['batch_content_sync.settings'];
  }

  public function getFormId() {
    return 'batch_content_sync_settings';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('batch_content_sync.settings');

    $form['qa_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('QA Environment URL'),
      '#default_value' => $config->get('qa_url'),
    ];

    $form['stage_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Stage Environment URL'),
      '#default_value' => $config->get('stage_url'),
    ];

    $form['prod_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Production Environment URL'),
      '#default_value' => $config->get('prod_url'),
    ];

    $form['existing_content_behavior'] = [
      '#type' => 'radios',
      '#title' => $this->t('In case of an existing content'),
      '#default_value' => $config->get('existing_content_behavior') ?? 'override',
      '#options' => [
        'override' => $this->t('Override existing content.'),
        'clone' => $this->t('Create a clone.'),
      ],
    ];

    $form['token_wrapper'] = [
      '#type' => 'container',
      '#attributes' => [
        'style' => 'display: flex; align-items: flex-end; gap: 10px;',
      ],
    ];
    
    $access_token = $config->get('access_token');

    $form['token_wrapper']['access_token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Access Token'),
      '#default_value' => $access_token ?? '',
      '#prefix' => '<div id="access-token-wrapper">',
      '#suffix' => '</div>',
      '#attributes' => ['style' => 'flex: 1;'],
      '#description' => $this->t('Used for authenticating incoming sync requests.'),
    ];

    $form['token_wrapper']['generate_token'] = [
      '#type' => 'button',
      '#value' => $this->t('Generate Token'),
      '#limit_validation_errors' => [],
      '#ajax' => [
        'callback' => '::generateTokenAjax',
        'wrapper' => 'access-token-wrapper',
        'effect' => 'fade',
      ],
      '#attributes' => [
        'style' => 'white-space: nowrap; margin-bottom: 47px;',
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  public function generateTokenAjax(array &$form, FormStateInterface $form_state) {
    $access_token_element = bin2hex(random_bytes(16));
    $form['token_wrapper']['access_token']['#value'] = $access_token_element;
    return $form['token_wrapper']['access_token'];
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('batch_content_sync.settings')
      ->set('qa_url', $form_state->getValue('qa_url'))
      ->set('stage_url', $form_state->getValue('stage_url'))
      ->set('prod_url', $form_state->getValue('prod_url'))
      ->set('access_token', $form_state->getValue('access_token'))
      ->set('existing_content_behavior', $form_state->getValue('existing_content_behavior'))
      ->save();
    parent::submitForm($form, $form_state);
  }
}
