<?php

namespace Drupal\batch_content_sync\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\batch_content_sync\Batch\ContentSyncBatch;

/**
 * @Action(
 *   id = "push_content_qa",
 *   label = @Translation("Push content to QA"),
 *   type = "node"
 * )
 */
class PushContentQA extends ActionBase {

  public function execute($entity = NULL) {
    $url = \Drupal::config('batch_content_sync.settings')->get('qa_url');
    if (empty($url)) {
      \Drupal::messenger()->addError($this->t('QA URL not configured.'));
      return;
    }
    // ✅ Get the correct language of the current entity (translation being pushed)
    $langcode = $entity->language()->getId();
    ContentSyncBatch::startBatch([$entity->id()], 'qa', $langcode);
  }

  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    return $object->access('view', $account, $return_as_object);
  }
}
