# Batch Content Sync

**Batch Content Sync** is a lightweight Drupal module for syncing content — including media, paragraphs, and taxonomy terms — between environments using custom REST endpoints.

This module is designed for use in multi-environment deployments where site editors or admins need to selectively synchronize nodes across QA, Stage, and Production environments.

---

## 🔧 Features

- Push content to QA, Stage, or Prod via UI or batch
- Custom REST endpoints for receiving normalized entity payloads
- Media and taxonomy term support
- Access token authentication (no contrib dependencies)
- Clean JSON logging of push attempts
- Lightweight and dependency-minimized
- Easy to integrate with automated pipelines or editorial workflows

---

## 🚀 Installation

1. Place the module in your Drupal installation under:  
   `modules/custom/batch_content_sync`

2. Enable it:

3. Configure the destination URLs and access token at:  
`/admin/config/content/batch-content-sync`

---

## 🧪 Usage

1. Go to the content overview page:  
`/admin/content`

2. Enable it:
   - via Admin UI or run `drush en batch_content_sync`

2. Select content, then choose:  
- **Push to QA**
- **Push to Stage**
- **Push to Prod**

---

## 🔐 Authentication

- This module uses a simple access token, configured via the admin UI.
- All incoming requests must include the token or will be denied.
- No external modules like `key_auth` are required.

---

## 📂 REST Endpoints

The module defines the following POST endpoints:

| Environment | Endpoint URL           |
|-------------|------------------------|
| QA          | `/api/push-content-qa` |
| Stage       | `/api/push-content-stage` |
| Prod        | `/api/push-content-prod` |

Each expects a normalized JSON payload of the entity being pushed.

---

## 📄 Dependencies
This module depends only on core modules:
- `rest`
- `serialization`
- `node`
- `media`

---

## 🛠️ Developer Notes
- Logs are stored in the `batch_content_sync_log` table.
- SyncService handles normalization, base64 encoding, and payload wrapping.
- ReceiverController manages entity creation, term resolution, and media decoding.
---

---
## 📜 License
GPL-2.0-or-later
---

## 🙏 Author

**Sohaib Mahtab**  
- [Drupal.org Profile](https://www.drupal.org/u/smahtab)  
- [LinkedIn](https://www.linkedin.com/in/smahtab/)
