<?php

namespace Drupal\batch_content_sync\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\batch_content_sync\Batch\ContentSyncBatch;

/**
 * @Action(
 *   id = "push_content_prod",
 *   label = @Translation("Push content to Prod"),
 *   type = "node"
 * )
 */
class PushContentProd extends ActionBase {

  public function execute($entity = NULL) {
    $url = \Drupal::config('batch_content_sync.settings')->get('prod_url');
    if (empty($url)) {
      \Drupal::messenger()->addError($this->t('Prod URL not configured.'));
      return;
    }
    // ✅ Get the correct language of the current entity (translation being pushed)
    $langcode = $entity->language()->getId();
    ContentSyncBatch::startBatch([$entity->id()], 'prod', $langcode);
  }

  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    return $object->access('view', $account, $return_as_object);
  }
}
