<?php

namespace Drupal\batch_content_sync\Plugin\rest\resource;

use Drupal\rest\Annotation\RestResource;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;

/**
 * @RestResource(
 *   id = "push_content_qa",
 *   label = @Translation("Push Content QA"),
 *   uri_paths = {
 *     "create" = "/api/push-content-qa"
 *   }
 * )
 */
class PushContentQa extends ResourceBase {
  public function post(array $data) {
    $nid = $data['nid'] ?? NULL;
    $result = \Drupal::service('batch_content_sync.sync_service')
      ->pushToRemote($nid, 'qa');
    return new ResourceResponse($result);
  }
}
