<?php

namespace Drupal\batch_content_sync\Plugin\rest\resource;

use Drupal\rest\Annotation\RestResource;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;

/**
 * @RestResource(
 *   id = "push_content_stage",
 *   label = @Translation("Push Content Stage"),
 *   uri_paths = {
 *     "create" = "/api/push-content-stage"
 *   }
 * )
 */
class PushContentStage extends ResourceBase {
  public function post(array $data) {
    $nid = $data['nid'] ?? NULL;
    $result = \Drupal::service('batch_content_sync.sync_service')
      ->pushToRemote($nid, 'stage');
    return new ResourceResponse($result);
  }
}
