<?php

namespace Drupal\batch_content_sync\Plugin\rest\resource;

use Drupal\rest\Annotation\RestResource;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;

/**
 * @RestResource(
 *   id = "push_content_prod",
 *   label = @Translation("Push Content Prod"),
 *   uri_paths = {
 *     "create" = "/api/push-content-prod"
 *   }
 * )
 */
class PushContentProd extends ResourceBase {
  public function post(array $data) {
    $nid = $data['nid'] ?? NULL;
    $result = \Drupal::service('batch_content_sync.sync_service')
      ->pushToRemote($nid, 'prod');
    return new ResourceResponse($result);
  }
}
