**Batch Messenger**

https://www.drupal.org/project/batch_messenger

[[_TOC_]]

# API

## Collection tracking

Dispatch messages as usual, but attach a `\Drupal\batch_messenger\Messenger\Stamp\CollectionItem` stamp with a common collection ID and unique message ID. Both IDs may be randomly generated strings between 1-128 characters in length. Errors will occur if duplicate ID pairs are dispatched.

```php
use \Symfony\Component\Messenger\Envelope;
use \Drupal\batch_messenger\Messenger\Stamp\CollectionItem;

/** @var \Symfony\Component\Messenger\MessageBusInterface $bus */
$bus = \Drupal::service(MessageBusInterface::class);

// Collections:
$collectionName = 'my-set-' . \mt_rand(111,999);
foreach (range(1, 60) as $i) {
  $bus->dispatch(new Envelope(
    message: new MyMessage(),
    stamps: [
      CollectionItem::create($collection, (string) $i)
    ],
  ));
}
```

# License

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
