<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Messenger\Middleware;

use Drupal\batch_messenger\BatchMessengerTracker;
use Drupal\batch_messenger\Messenger\Stamp\CollectionItem;
use Drupal\batch_messenger\Messenger\Stamp\CollectionItemMarkedPending;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\Middleware\MiddlewareInterface;
use Symfony\Component\Messenger\Middleware\StackInterface;

/**
 * @see \Drupal\batch_messenger\Messenger\Stamp\CollectionItem
 */
final class BatchMessengerEntryMiddleware implements MiddlewareInterface {

  public function __construct(
    private BatchMessengerTracker $batchMessengerTracker,
  ) {
  }

  public function handle(Envelope $envelope, StackInterface $stack): Envelope {
    if (NULL !== ($stamp = $envelope->last(CollectionItem::class))) {
      if (NULL === $envelope->last(CollectionItemMarkedPending::class)) {
        $this->batchMessengerTracker->addPending($stamp->getCollection(), $stamp->getIdentifier());
        $envelope = $envelope->with(CollectionItemMarkedPending::create());
      }
    }

    return $stack->next()->handle($envelope, $stack);
  }

}
