<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Ui\Controller;

use Drupal\batch_messenger\BatchMessengerTracker;
use Drupal\batch_messenger\Ui\EventListener\RouteSubscriber;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

final class ClearCompleteController extends ControllerBase {

  public function __construct(
    private BatchMessengerTracker $batchMessengerTracker,
  ) {}

  public function __invoke(): Response {
    $this->batchMessengerTracker->clearCompleteCollections();

    $this->messenger()->addMessage('Cleared completed collections.');

    return new RedirectResponse(Url::fromRoute(RouteSubscriber::COLLECTION_ROUTE_NAME)->toString());
  }

}
