<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Ui\EventListener;

use Drupal\batch_messenger\Ui\Controller\ClearCompleteController;
use Drupal\batch_messenger\Ui\Controller\CollectionController;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * @internal
 */
final class RouteSubscriber extends RouteSubscriberBase {

  public const COLLECTION_ROUTE_NAME = 'batch_messenger.ui.collection';
  public const CLEAR_COMPLETE_ROUTE_NAME = 'batch_messenger.ui.clear_complete';

  protected function alterRoutes(RouteCollection $collection): void {
    $collection->add(static::COLLECTION_ROUTE_NAME, (new Route(path: '/admin/reports/batch-messenger'))
      ->setDefault('_controller', CollectionController::class)
      ->setDefault('_title', 'Message sets')
      ->addRequirements([
        '_permission' => 'batch_messenger ui view all batches',
      ]),
    );

    $collection->add(static::CLEAR_COMPLETE_ROUTE_NAME, (new Route(path: '/admin/reports/batch-messenger/clear-complete'))
      ->setDefault('_controller', ClearCompleteController::class)
      ->addRequirements([
        // @todo maybe something more granular?
        '_permission' => 'batch_messenger ui view all batches',
        '_csrf_token' => TRUE,
      ]),
    );
  }

}
