<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Ui;

use Drupal\batch_messenger\Ui\EventListener\RouteSubscriber;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;

final class BatchMessengerUiCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    if ($container->getParameter('batch_messenger.ui') !== TRUE) {
      return;
    }

    $container->setDefinition(RouteSubscriber::class, (new Definition(RouteSubscriber::class))
      // Subscribers must be public :/.
      ->setPublic(TRUE)
      ->setAutowired(TRUE)
      ->addTag('event_subscriber'),
    );
  }

}
