<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\BatchBridge;

final class BatchMessengerClaimedItem {

  /**
   * @phpstan-param array{callable, array<mixed>} $data
   */
  private function __construct(
    public array $data,
  ) {
  }

  /**
   * @phpstan-param callable $callback
   * @phpstan-param array<mixed> $args
   */
  public static function create($callback, $args): static {
    return new static([
      $callback, $args,
    ]);
  }

}
