<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\BatchBridge\Messenger;

use Drupal\batch_messenger\BatchBridge\BatchMessengerBatchContextManager;
use Drupal\batch_messenger\BatchMessengerMessengerWrapper;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

/**
 * @internal
 */
final class FinishBatchHandler {

  public function __construct(
    private BatchMessengerBatchContextManager $batchContextManager,
    private BatchMessengerMessengerWrapper $messengerWrapper,
    #[Autowire(service: 'logger.channel.batch_messenger.finish')]
    private LoggerInterface $logger,
  ) {
  }

  /**
   * @see \_batch_finished()
   */
  public function __invoke(FinishBatch $message): void {
    $finishCallback = $this->batchContextManager->getFinishCallback($message->collection);
    $results = $this->batchContextManager->getResults($message->collection);

    $this->messengerWrapper->wrapMessengerMessages(
      static function () use ($finishCallback, $results): void {
        if ($finishCallback !== NULL) {
          $finishCallback(
          // Success:
            TRUE,
            // Results:
            \iterator_to_array($results),
            // Operations:
            [],
            // formatInterval:
            '',
          );
        }
      },
      logger: $this->logger,
      logTemplate: 'Batch for @collection completed with: @message',
      logArgs: ['@collection' => $message->collection],
    );

    $this->logger->info('Batch for @collection completed.', [
      '@collection' => $message->collection,
    ]);
  }

}
