<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\BatchBridge;

use Drupal\batch_messenger\BatchBridge\Messenger\FinishBatchHandler;
use Drupal\batch_messenger\BatchBridge\Messenger\LegacyBatchItemHandler;
use Drupal\batch_messenger\BatchBridge\Messenger\Middleware\BatchBridgePostHandleMiddleware;
use Symfony\Component\DependencyInjection\ChildDefinition;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;

final class BatchBridgeCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    if ($container->getParameter('batch_messenger.batch_bridge') !== TRUE) {
      return;
    }

    try {
      // @todo via Stamps.module
      // @todo do not tie to param, use a proper locator.
      /** @var array<string, array{middleware: array<mixed>}> $buses */
      $buses = $container->getParameter('sm.buses');
    }
    catch (ParameterNotFoundException) {
      $buses = [];
    }

    foreach ($buses as $id => $bus) {
      $buses[$id]['middleware'][] = ['id' => 'batch_messenger.batch_bridge.post_handle'];
    }
    $container->setParameter('sm.buses', $buses);

    $container->setDefinition(
      BatchMessengerBatchContextManager::class,
      (new Definition(BatchMessengerBatchContextManager::class))
        ->setPublic(TRUE)
        ->setAutowired(TRUE)
        ->setAutoconfigured(TRUE),
    );

    $container->setDefinition(
      'messenger.middleware.batch_messenger.batch_bridge.post_handle',
      (new Definition(BatchBridgePostHandleMiddleware::class))
        ->setPublic(TRUE)
        ->setAutowired(TRUE)
        ->setAutoconfigured(TRUE)
        ->setAbstract(TRUE),
    );

    $container->setDefinition(
      LegacyBatchItemHandler::class,
      (new Definition(LegacyBatchItemHandler::class))
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE)
        ->addTag('messenger.message_handler'),
    );

    $container->setDefinition(
      FinishBatchHandler::class,
      (new Definition(FinishBatchHandler::class))
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE)
        ->addTag('messenger.message_handler'),
    );

    $container->setDefinition(
      'logger.channel.batch_messenger.operation',
      (new ChildDefinition(parent: 'logger.channel_base'))
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE)
        ->setArguments(['batch_messenger.operation']),
    );

    $container->setDefinition(
      'logger.channel.batch_messenger.finish',
      (new ChildDefinition(parent: 'logger.channel_base'))
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE)
        ->setArguments(['batch_messenger.finish']),
    );
  }

}
