<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\BatchBridge;

/**
 * Identifier secretly appended to operation arguments, then removed when converting from a batch operation to a message.
 *
 * @internal
 */
final class BatchMessengerItemIdentifier {

  /**
   * @phpstan-param non-empty-string $identifier
   */
  private function __construct(
    public string $identifier,
  ) {
  }

  /**
   * @phpstan-param non-empty-string $identifier
   */
  public static function create(
    string $identifier,
  ): static {
    return new static($identifier);
  }

}
