<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\BatchBridge\Messenger;

use Drupal\batch_messenger\Messenger\Stamp\CollectionItem;

/**
 * @internal
 */
final class LegacyBatchItem {

  /**
   * @phpstan-param callable-string $callback
   * @phpstan-param array<mixed> $arguments
   */
  private function __construct(
    private string $callback,
    private array $arguments,
    public CollectionItem $collectionItem,
  ) {
  }

  /**
   * @phpstan-param callable-string $callback
   * @phpstan-param array<mixed> $arguments
   */
  public static function create(string $callback, array $arguments, CollectionItem $collectionItem): static {
    return new static($callback, $arguments, $collectionItem);
  }

  /**
   * @phpstan-param array{sandbox: array<mixed>, results: array<mixed>, finished: array<mixed>, message: array<mixed>} $batch_context
   */
  public function __invoke(array &$batch_context): mixed {
    return ($this->callback)(...$this->arguments, ...[&$batch_context]);
  }

}
