<?php

declare(strict_types=1);

namespace Drupal\batch_messenger;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;

final class BatchMessengerCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    try {
      // @todo via Stamps.module
      // @todo do not tie to param, use a proper locator.
      /** @var array<string, array{middleware: array<mixed>}> $buses */
      $buses = $container->getParameter('sm.buses');
    }
    catch (ParameterNotFoundException) {
      $buses = [];
    }

    foreach ($buses as $id => $bus) {
      $buses[$id]['middleware'][] = ['id' => 'batch_messenger.entry'];
      $buses[$id]['middleware'][] = ['id' => 'batch_messenger.post_handle'];
    }
    $container->setParameter('sm.buses', $buses);
  }

}
