<?php

declare(strict_types=1);

namespace Drupal\batch_messenger;

use Symfony\Component\DependencyInjection\Argument\IteratorArgument;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * @todo
 * Maybe instead of this we can just do the stack business in Middleware::handle upfront then logic afterwards?
 */
final class BatchMessengerReorderCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    foreach (\array_keys($container->findTaggedServiceIds('messenger.bus')) as $busId) {
      $bus = $container->getDefinition($busId);

      /** @var \Symfony\Component\DependencyInjection\Argument\IteratorArgument $arg */
      $arg = $bus->getArgument(0);
      /** @var \Symfony\Component\DependencyInjection\Reference[] $references */
      $references = $arg->getValues();

      $foundHandler = FALSE;
      $foundPostHandle = FALSE;
      $foundPostHandle2 = FALSE;
      $postHandle = NULL;
      $postHandle2 = NULL;
      foreach ($references as $k => $reference) {
        if (\sprintf('%s.middleware.handle_message', $busId) === (string) $reference) {
          $foundHandler = TRUE;
        }
        elseif (\sprintf('%s.middleware.batch_messenger.post_handle', $busId) === (string) $reference) {
          $foundPostHandle = TRUE;
          $postHandle = $reference;
          unset($references[$k]);
        }
        elseif (\sprintf('%s.middleware.batch_messenger.batch_bridge.post_handle', $busId) === (string) $reference) {
          $foundPostHandle2 = TRUE;
          $postHandle2 = $reference;
          unset($references[$k]);
        }
      }

      if (!$foundPostHandle && !$foundPostHandle2) {
        // The post-handler may have been removed by some other alterations.
        // Ignore when this happens.
        continue;
      }

      if ($foundHandler === FALSE) {
        throw new \LogicException('Couldn\'t find handler. Something changed with Symfony or SM.');
      }

      // Move the handler to after the handler.
      if ($postHandle !== NULL) {
        $references[] = $postHandle;
      }
      if ($postHandle2 !== NULL) {
        $references[] = $postHandle2;
      }

      // Put it all back together again.
      $bus->setArgument(0, new IteratorArgument($references));
    }
  }

}
