<?php

declare(strict_types=1);

namespace Drupal\batch_messenger;

use Drupal\batch_messenger\BatchBridge\BatchBridgeCompilerPass;
use Drupal\batch_messenger\Ui\BatchMessengerUiCompilerPass;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderInterface;

final class BatchMessengerServiceProvider implements ServiceProviderInterface {

  public function register(ContainerBuilder $container): void {
    $container
      // 100 is before MessengerPass.
      ->addCompilerPass(new BatchMessengerCompilerPass(), priority: 100)
      ->addCompilerPass(new BatchMessengerReorderCompilerPass(), priority: -100);

    $container
      ->addCompilerPass(new BatchMessengerUiCompilerPass())
      ->addCompilerPass(new BatchBridgeCompilerPass());
  }

}
