<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Messenger\Middleware;

use Drupal\batch_messenger\BatchMessengerTracker;
use Drupal\batch_messenger\Messenger\Stamp\CollectionItem;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\Middleware\MiddlewareInterface;
use Symfony\Component\Messenger\Middleware\StackInterface;

/**
 * @see \Drupal\batch_messenger\Messenger\Stamp\CollectionItem
 */
final class BatchMessengerPostHandleMiddleware implements MiddlewareInterface {

  public function __construct(
    private BatchMessengerTracker $batchMessengerTracker,
  ) {
  }

  public function handle(Envelope $envelope, StackInterface $stack): Envelope {
    if (NULL !== ($stamp = $envelope->last(CollectionItem::class))) {
      $this
        ->batchMessengerTracker
        ->transferPendingToProcessed($stamp->getCollection(), $stamp->getIdentifier());
    }

    return $stack->next()->handle($envelope, $stack);
  }

}
