<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Messenger\Stamp;

use Symfony\Component\Messenger\Stamp\StampInterface;

/**
 * Represents when a message is one item amongst many similar messages.
 */
final class CollectionItem implements StampInterface {

  /**
   * @phpstan-param non-empty-string $collection
   * @phpstan-param non-empty-string $identifier
   */
  private function __construct(
    private string $collection,
    private string $identifier,
  ) {
  }

  /**
   * @phpstan-param non-empty-string $collection
   * @phpstan-param non-empty-string $identifier
   */
  public static function create(
    string $collection,
    string $identifier,
  ): static {
    return new static($collection, $identifier);
  }

  /**
   * @phpstan-return non-empty-string
   */
  public function getCollection(): string {
    return $this->collection;
  }

  /**
   * @phpstan-return non-empty-string
   */
  public function getIdentifier(): string {
    return $this->identifier;
  }

}
