<?php

declare(strict_types=1);

namespace Drupal\batch_messenger\Ui;

use Drupal\batch_messenger\Ui\EventListener\RouteSubscriber;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;

final class BatchMessengerUiCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    if ($container->getParameter('batch_messenger.ui') !== TRUE) {
      return;
    }

    $moduleName = 'batch_messenger';

    $container->setDefinition(RouteSubscriber::class, (new Definition(RouteSubscriber::class))
      // Subscribers must be public :/.
      ->setPublic(TRUE)
      ->setAutowired(TRUE)
      ->addTag('event_subscriber'),
    );

    // Hooks.
    // Pretty gross, maybe things will improve after https://www.drupal.org/project/drupal/issues/3526411/
    $container->setDefinition(
      UiHooks::class,
      $hooksDefinition = (new Definition(UiHooks::class))
        ->setPublic(TRUE)
        ->setAutowired(TRUE)
        ->setAutoconfigured(TRUE),
    );
    /** @var array<string, array<string, array<string, string>>> $map */
    $map = $container->getParameter('hook_implementations_map');
    foreach ([
      ['menuLinksDiscoveredAlter', 'menu_links_discovered_alter'],
      ['toolbar', 'toolbar'],
      ['menuLocalActionsAlter', 'menu_local_actions_alter'],
      ['libraryInfoBuild', 'library_info_build'],
    ] as [$methodName, $hook]) {
      $map[$hook][UiHooks::class][$methodName] = $moduleName;
      $hooksDefinition->addTag('kernel.event_listener', [
        'event' => \sprintf('drupal_hook.%s', $hook),
        'method' => $methodName,
        'priority' => 0,
      ]);
    }
    $container->setParameter('hook_implementations_map', $map);
  }

}
